//=============================================================================
// A box used for holding parts for custom weapons.
//=============================================================================
class WeaponCraftBox extends DeusExPickup;

#exec TEXTURE IMPORT NAME=WeaponCraftIcon FILE=Textures\WeaponCraftIcon.PCX GROUP=Icons //Icons

enum EWepModel
{
        WM_Undecided,
	WM_AssaultRifle,
	WM_StealthPistol,
	WM_AssaultShotgun,
	WM_Pistol,
	WM_SawedOffShotgun,
	WM_SniperRifle,
	WM_KS23,
	WM_Saiga12
};

enum EWepType
{
        WT_Undecided,
	WT_SMG,
	WT_Rifle,
	WT_Shotgun,
	WT_Handgun,
	WT_AutoShotgun,
        WT_AssaultRifle
};

var EWepModel CraftMesh;
var bool bSpecAcc, bSpecPen, bSpecDam, bSpecScope, bSpecSilencer, bSpecKnockBack, bSpecClipSize, bSpecRecoil, bSpecRange;
var class<Ammo> CraftAmmo;
//var bool bCraftSpread;
var EWepType WeaponType;
var sound FireSound, SelectSound, ReloadSound, FinishReloadSound;

//===================================
//Specialization Set Functions
//===================================
function SetSpecialization(string SpecType)
{
 local int i;
 
 i = NumSpecProperties();
 
 if (i > 2)
 {
  AntiCheat();
  return;
 }
 if (GetPropertyText(SpecType) ~= "")
 {
  Pawn(Owner).ClientMessage("|p2Invalid Specialization Type. REPORT THIS AS A BUG.");
  return;
 }
 if (GetPropertyText(SpecType) ~= "True")
 {
  Pawn(Owner).ClientMessage("|cf88You already have this specialization type.");  
  return;
 }
 if (i < 2)
 {
  SetPropertyText(SpecType, "True");
  Pawn(Owner).ClientMessage("|p4Weapon Specialization #"$i + 1$" Set.");
  return;
 }
}

function ClearSpecializations()
{
 bSpecAcc = False;
 bSpecPen = False;
 bSpecDam = False;
 bSpecScope = False;
 bSpecSilencer = False;
 bSpecKnockBack = False;
 bSpecClipSize = False;
 bSpecRecoil = False;
 bSpecRange = False;
}

//===================================
//Model Compatiability Check
//===================================

function bool IsCompatible(string TestModel)
{
 
 if (WeaponType == WT_SMG)
 {

  if (TestModel ~= "WM_StealthPistol" || TestModel ~= "WM_AssaultRifle")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_Rifle)
 {
  if (TestModel ~= "WM_SniperRifle" || TestModel ~= "WM_AssaultRifle")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_Shotgun)
 {
  if (TestModel ~= "WM_SawedOffShotgun" || TestModel ~= "WM_KS23")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_Handgun)
 {
  if (TestModel ~= "WM_StealthPistol" || TestModel ~= "WM_Pistol")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_AutoShotgun)
 {
  if (TestModel ~= "WM_Saiga12" || TestModel ~= "WM_AssaultShotgun")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_AssaultRifle)
 {
  if (TestModel ~= "WM_Saiga12" || TestModel ~= "WM_AssaultRifle")
  {
   return True;
  }
 }
 
 if (WeaponType == WT_Undecided || TestModel ~= "WM_Undecided" || TestModel ~= "")
 {
  return True; //this is handled elsewhere
 }
 
 return false;
}

//===================================
//Feature Setting Code Start
//===================================
function SetAmmo(Class<Ammo> NewAmmo)
{
 if (NewAmmo == None)
 {
  Pawn(Owner).ClientMessage("|p2No ammo type set for your selection. REPORT THIS AS A BUG.");
  return;
 }
 
 CraftAmmo = NewAmmo;
 Pawn(Owner).ClientMessage("|p4Custom Weapon Ammunition Type is now "$NewAmmo.Default.ItemName$"!");
}

function SetModel(string NewModel)
{
 if (!IsCompatible(NewModel))
 {
  Pawn(Owner).ClientMessage("|cf88 Weapon Model is incompatible.");
  return;
 }
 
 if (WeaponType == WT_Undecided)
 {
  Pawn(Owner).ClientMessage("|cf88 You must choose a weapon type first.");
  return;
 }
 
 if (NewModel ~= "WM_Undecided" || NewModel ~= "")
 {
  Pawn(Owner).ClientMessage("|p2No weapon model set for your selection. REPORT THIS AS A BUG.");
  return;
 }
 
 SetPropertyText("CraftMesh", NewModel);
 Pawn(Owner).ClientMessage("|p4Custom Weapon Model is now a(n) "$Right(NewModel, Len(NewModel) - 1 - InStr(NewModel, "_"))$"!");
}

function SetType(string NewType)
{
 SetPropertyText("WeaponType", NewType);
 Pawn(Owner).ClientMessage("|p4Custom Weapon Type is now a(n) "$Right(NewType, Len(NewType) - 1 - InStr(NewType, "_"))$"!");

 if (CAPS(String(WeaponType)) != CAPS(NewType))
 {
  CraftMesh = WM_Undecided;
  Pawn(Owner).ClientMessage("|p4Custom Weapon Model Reset.");
 }
}

//===================================
//Feature Setting Code END
//===================================

function int NumSpecProperties()
{
 local int i;
 
 if (bSpecAcc) i++;
 if (bSpecPen) i++;
 if (bSpecDam) i++;
 if (bSpecScope) i++;
 if (bSpecSilencer) i++;
 if (bSpecKnockBack) i++;
 if (bSpecClipSize) i++;
 if (bSpecRecoil) i++;
 if (bSpecRange) i++;
 
 if (i > 2)
 {
  AntiCheat();
  return 0;
 }
 
 return i;
}

function AntiCheat()
{
  Pawn(Owner).ClientMessage("|cf88 Cheat Detected. Destroying Box.");
  Destroy();
}

function CheckSounds(out int bFireSound, out int bReloadSound, out int bReloadEndSound, out int bSelectSound)
{
 if (FireSound != None) bFireSound = 1;
 if (ReloadSound != None) bReloadSound = 1;
 if (FinishReloadSound != None) bReloadEndSound = 1;
 if (SelectSound != None) bSelectSound = 1;
}

//===================================
//Check Progress Code Start
//===================================

function bool CheckProgress(bool bManual)
{
 local int i;
 local bool bHasModel, bHasType, bHasAmmoType;
 local bool bHFS, bHRS, bHRES, bHSS;

 local int FS, RS, RES, SS;

 local string S;
 
 i = NumSpecProperties();
 
 if (i > 2)
 {
  AntiCheat();
  return false;
 }
 
 CheckSounds(FS, RS, RES, SS);
 
 bHFS = Bool(FS);
 bHRS = Bool(RS);
 bHRES = Bool(RES);
 bHSS = Bool(SS);

 if (CraftMesh != WM_Undecided)
 {
  bHasModel = True;
 }
 
 if (WeaponType != WT_Undecided)
 {
  bHasType = True;
 }
 
 if (CraftAmmo != None)
 {
  bHasAmmoType = True;
 }
 
 if (!bHasType)
 {
  Pawn(Owner).ClientMessage("|cf88You must still choose your custom |p4weapon type.");
  return false;
 }
 
 if (!bHasModel)
 {
  Pawn(Owner).ClientMessage("|cf88You must still choose your custom weapon's |p43D model.");
  return false;
 }
 
 if (!bHasAmmoType)
 {
  Pawn(Owner).ClientMessage("|cf88You must still choose your custom weapon's |p4ammunition type.");
  return false;
 }

 if (i < 2)
 {
  Pawn(Owner).ClientMessage("|p4You still have "$2 - i$" weapon specialization(s) you can choose.");
  return false;
 }
 
 if (!bHFS || !bHRS || !bHRES || !bHSS)
 {
  S = "|p4";
  if (!bHFS) S = S$"Firing. ";
  if (!bHRS) S = S@"Reloading.";
  if (!bHRES) S = S@"Finish Reloading.";
  if (!bHSS) S = S@"Selecting.";
  Pawn(Owner).ClientMessage("|cf88 You must still need the following sounds: "$S$"");
  return false;
 }
 
 		// at the cost of "$CheckCost()$"
 
 if (bManual) Pawn(Owner).ClientMessage("|p4Your weapon is ready for creation.");
 return True;
}

function int CheckCost()
{
 local int TotalCost;
 
 if (WeaponType == WT_SMG) TotalCost += 450;
 if (WeaponType == WT_Handgun) TotalCost += 275;
 if (WeaponType == WT_Rifle) TotalCost += 625;
 if (WeaponType == WT_AssaultRifle) TotalCost += 650;
 if (WeaponType == WT_Shotgun) TotalCost += 400;
 if (WeaponType == WT_AutoShotgun) TotalCost += 700;

 if (bSpecAcc) TotalCost += 150;
 if (bSpecPen) TotalCost += 100;
 if (bSpecDam) TotalCost += 225;
 if (bSpecScope) TotalCost += 175;
 if (bSpecSilencer) TotalCost += 200;
 if (bSpecKnockBack) TotalCost += 225;
 if (bSpecClipSize) TotalCost += 300;
 if (bSpecRecoil) TotalCost += 250;
 if (bSpecRange) TotalCost += 125;
 
 return TotalCost;
}

//===================================
//Check Progress Code END
//===================================

//-------------------------------
//Mesh Import Crap
//-------------------------------
#exec OBJ LOAD FILE=CoreTexGlass

#exec TEXTURE IMPORT NAME=CrapCardboard FILE=Textures\CrapCardboard.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=CrapFiller FILE=Textures\CrapFiller.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=CrapSharpee FILE=Textures\CrapSharpee.PCX GROUP=Skins

#exec MESH IMPORT MESH=CrapBox ANIVFILE=MODELS\CrapBox_a.3d DATAFILE=MODELS\CrapBox_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CrapBox X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=CrapBox SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CrapBox SEQ=CrapBox STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=CrapBox MESH=CrapBox
#exec MESHMAP SCALE MESHMAP=CrapBox X=0.042970125 Y=0.042970125 Z=0.042970125

#exec MESHMAP SETTEXTURE MESHMAP=CrapBox NUM=0 TEXTURE=CrapCardboard
#exec MESHMAP SETTEXTURE MESHMAP=CrapBox NUM=1 TEXTURE=07WindOpacStrek
#exec MESHMAP SETTEXTURE MESHMAP=CrapBox NUM=2 TEXTURE=CrapSharpee
#exec MESHMAP SETTEXTURE MESHMAP=CrapBox NUM=3 TEXTURE=CrapFiller

//#exec TEXTURE IMPORT NAME=IconCrapBox FILE=Textures\IconCrapBox.PCX GROUP=Icons FLAGS=2// Icon

state Activated
{
	function Activate()
	{
		CheckProgress(True);
	}

	function BeginState()
	{
		CheckProgress(True);
	}
Begin:
}

defaultproperties
{
     Texture=Texture'07WindOpacStrek'
     bCanHaveMultipleCopies=False
     ItemName="Weapon Parts Box"
     ItemArticle="a"
     bActivatable=True
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'CrapBox'
     PickupViewMesh=LodMesh'CrapBox'
     ThirdPersonMesh=LodMesh'CrapBox'
     LandSound=Sound'DeusExSounds.Generic.SplashSmall'
     Icon=Texture'WeaponCraftIcon'
     largeIcon=Texture'WeaponCraftIcon'
     largeIconWidth=36
     largeIconHeight=36
     Description="A box for carrying crap in, in this case it's for collecting parts for a custom weapon.."
     beltDescription="CUS WEP"
     Mesh=LodMesh'CrapBox'
     CollisionRadius=11.000000
     CollisionHeight=11.000000
     Mass=30.000000
     Buoyancy=30.000000
     M_Activated=""
     M_Selected=""
     M_Deactivated=""
}
